#ifndef _FileLogger_h__
#define _FileLogger_h__

#include "Utils/ILogger.h"
#include <GSTenums.h>
#include <buildspec.h>

namespace GST
{
namespace Utils
{

class GST_API_EXPORT FileLogger : public ILogger
{
public:
	FileLogger();

	virtual void printError(const std::string &msg);
	virtual void printWarning(const std::string &msg);
	virtual void printStatus(const std::string &msg);
	virtual void printDebug(const std::string &msg);
	virtual void printNetworkPID(const long &pid, const std::string &sql);

	void setLogFilePath(const std::string &filePath);
	std::string getLogFilePath() const;

	Utils::LogLevel getLogFilter() const;
	void setLogFilter(Utils::LogLevel val);

	/**
	 * @retuns a file name in the style: yyyy-mm-dd_hh-mm-ss.log
	 * with the current day time stamp
	 */
	static std::string GetUsefullLogFileName();

protected:
	std::string m_logFilePath;
	Utils::LogLevel m_logFilter;

	void writeToLogFile(const std::string &msg);
};

} // namespace Utils
} // namespace GST

#endif // _FileLogger_h__
